/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.handler;

import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import committee.nova.mods.avaritia.common.item.InfinityArmorItem;
import committee.nova.mods.avaritia.util.PlayerUtils;
import committee.nova.mods.avaritia.util.ToolUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class AbilityHandler {
    public static final Set<String> entitiesWithHelmets = new HashSet<String>();
    public static final Set<String> entitiesWithLeggings = new HashSet<String>();
    public static final Set<String> entitiesWithBoots = new HashSet<String>();
    public static final Map<String, FlightInfo> entitiesWithFlight = new HashMap<String, FlightInfo>();

    @SubscribeEvent
    public static void updateAbilities(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            String key = player.m_36316_().getName() + ":" + player.m_9236_().f_46443_;
            boolean hasHelmet = ToolUtils.isPlayerWearing(event.getEntity(), EquipmentSlot.HEAD, item -> item instanceof InfinityArmorItem);
            boolean hasChest = ToolUtils.isPlayerWearing(event.getEntity(), EquipmentSlot.CHEST, item -> item instanceof InfinityArmorItem);
            boolean hasLeggings = ToolUtils.isPlayerWearing(event.getEntity(), EquipmentSlot.LEGS, item -> item instanceof InfinityArmorItem);
            boolean hasBoots = ToolUtils.isPlayerWearing(event.getEntity(), EquipmentSlot.FEET, item -> item instanceof InfinityArmorItem);
            AbilityHandler.handleHelmetStateChange(player, key, hasHelmet);
            AbilityHandler.handleChestStateChange(player, key, hasChest);
            AbilityHandler.handleLeggingsStateChange(player, key, hasLeggings);
            AbilityHandler.handleBootsStateChange(player, key, hasBoots);
        }
    }

    private static void handleChestStateChange(Player player, String key, boolean hasChest) {
        boolean isFlyingGameMode = !PlayerUtils.isPlayingMode(player);
        FlightInfo flightInfo = entitiesWithFlight.computeIfAbsent(key, uuid -> new FlightInfo());
        if (isFlyingGameMode || hasChest) {
            if (!flightInfo.hadFlightItem) {
                if (!player.m_150110_().f_35936_) {
                    AbilityHandler.updateClientServerFlight(player, true);
                }
                flightInfo.hadFlightItem = true;
            } else if (flightInfo.wasFlyingGameMode && !isFlyingGameMode) {
                AbilityHandler.updateClientServerFlight(player, true, flightInfo.wasFlying);
            } else if (flightInfo.wasFlyingAllowed && !player.m_150110_().f_35936_) {
                AbilityHandler.updateClientServerFlight(player, true, flightInfo.wasFlying);
            }
            flightInfo.wasFlyingGameMode = isFlyingGameMode;
            flightInfo.wasFlying = player.m_150110_().f_35935_;
            flightInfo.wasFlyingAllowed = player.m_150110_().f_35936_;
            if (hasChest) {
                ArrayList effects = Lists.newArrayList((Iterable)player.m_21220_());
                for (MobEffectInstance potion2 : Collections2.filter((Collection)effects, potion -> !potion.m_19544_().m_19486_())) {
                    player.m_21195_(potion2.m_19544_());
                }
            }
        } else {
            if (flightInfo.hadFlightItem) {
                if (player.m_150110_().f_35936_) {
                    AbilityHandler.updateClientServerFlight(player, false);
                }
                flightInfo.hadFlightItem = false;
            }
            flightInfo.wasFlyingGameMode = false;
            flightInfo.wasFlying = player.m_150110_().f_35935_;
            flightInfo.wasFlyingAllowed = player.m_150110_().f_35936_;
        }
    }

    private static void handleHelmetStateChange(Player player, String key, boolean hasHelmet) {
        if (hasHelmet) {
            if (entitiesWithHelmets.contains(key)) {
                player.m_20301_(300);
                player.m_36324_().m_38705_(20);
                player.m_36324_().m_38717_(20.0f);
                MobEffectInstance nv = player.m_21124_(MobEffects.f_19611_);
                if (nv == null) {
                    nv = new MobEffectInstance(MobEffects.f_19611_, 300, 0, false, false);
                    player.m_7292_(nv);
                }
                nv.f_19503_ = 300;
            } else {
                entitiesWithHelmets.add(key);
            }
        } else {
            entitiesWithHelmets.remove(key);
        }
    }

    private static void handleLeggingsStateChange(Player player, String key, boolean hasLeggings) {
        if (hasLeggings) {
            if (entitiesWithLeggings.contains(key)) {
                if (player.m_6060_()) {
                    player.m_20095_();
                    player.m_5825_();
                }
            } else {
                entitiesWithLeggings.add(key);
            }
        } else {
            entitiesWithLeggings.remove(key);
        }
    }

    private static void handleBootsStateChange(Player player, String key, boolean hasBoots) {
        if (hasBoots) {
            if (entitiesWithBoots.contains(key)) {
                player.m_274367_(1.0625f);
                boolean flying = player.m_150110_().f_35935_;
                boolean swimming = player.m_20069_();
                boolean sneaking = player.m_6047_();
                if (player.m_20096_() || flying || swimming) {
                    float speed = 0.1f * (flying ? 1.1f : 1.0f) * (swimming ? 1.2f : 1.0f) * (sneaking ? 0.1f : 1.0f);
                    if (player.f_20902_ > 0.0f) {
                        player.m_19920_(speed, new Vec3(0.0, 0.0, 1.0));
                    } else if (player.f_20902_ < 0.0f) {
                        player.m_19920_(-speed * 0.25f, new Vec3(0.0, 0.0, 1.0));
                    }
                    if (player.f_20900_ != 0.0f) {
                        player.m_19920_(speed * 0.45f * Math.signum(player.f_20900_), new Vec3(1.0, 0.0, 0.0));
                    }
                }
                if (player.m_20142_()) {
                    float f = player.m_146908_() * ((float)Math.PI / 180);
                    player.m_20256_(player.m_20184_().m_82520_((double)(-Mth.m_14031_((float)f) * 0.2f), 0.0, (double)(Mth.m_14089_((float)f) * 0.2f)));
                }
            } else {
                entitiesWithBoots.add(key);
            }
        } else {
            player.m_274367_(0.6f);
            entitiesWithBoots.remove(key);
        }
    }

    @SubscribeEvent
    public static void jumpBoost(LivingEvent.LivingJumpEvent event) {
        Player player;
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player && entitiesWithBoots.contains((player = (Player)entity).m_36316_().getName() + ":" + player.m_9236_().f_46443_) && player.m_20142_()) {
            player.m_20256_(player.m_20184_().m_82520_(0.0, (double)0.305f, 0.0));
        }
    }

    @SubscribeEvent
    public static void onPlayerDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        AbilityHandler.stripAbilities(event.getEntity());
        AbilityHandler.reapplyFly(event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        AbilityHandler.stripAbilities(event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        AbilityHandler.stripAbilities(event.getEntity());
        AbilityHandler.clearFly(event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        AbilityHandler.stripAbilities(event.getEntity());
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player entity = (Player)livingEntity;
            AbilityHandler.stripAbilities(entity);
        }
    }

    private static void stripAbilities(Player player) {
        String key = player.m_36316_().getName() + ":" + player.m_9236_().f_46443_;
        entitiesWithHelmets.remove(key);
        entitiesWithFlight.remove(key);
        entitiesWithLeggings.remove(key);
        entitiesWithBoots.remove(key);
    }

    private static void clearFly(Player player) {
        entitiesWithFlight.remove(player.m_36316_().getName() + ":" + player.m_9236_().f_46443_);
    }

    private static void reapplyFly(Player player) {
        FlightInfo flightInfo = entitiesWithFlight.get(player.m_36316_().getName() + ":" + player.m_9236_().f_46443_);
        if (flightInfo != null && (flightInfo.wasFlyingAllowed || flightInfo.wasFlying)) {
            AbilityHandler.updateClientServerFlight(player, flightInfo.wasFlyingAllowed, flightInfo.wasFlying);
        }
    }

    private static void updateClientServerFlight(Player player, boolean allowFlying) {
        AbilityHandler.updateClientServerFlight(player, allowFlying, allowFlying && player.m_150110_().f_35935_);
    }

    private static void updateClientServerFlight(Player player, boolean allowFlying, boolean isFlying) {
        player.m_150110_().f_35936_ = allowFlying;
        player.m_150110_().f_35935_ = isFlying;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.m_6885_();
        }
    }

    public static class FlightInfo {
        public boolean hadFlightItem;
        public boolean wasFlyingGameMode;
        public boolean wasFlyingAllowed;
        public boolean wasFlying;
    }
}

